{
    Info << nl << "Solving fuel scalars" << endl;

    tmp<fv::convectionScheme<scalar> > yConvection
    (
        fv::convectionScheme<scalar>::New
        (
            fuelMesh,
            fuelYs,
            phiFuel,
            fuelMesh.divScheme("div(phi,y)")
        )
    );
    volScalarField eFuel = matFuel.epsilon0()*(1.0 - sFuel);
    surfaceScalarField eFuelf = fvc::interpolate(eFuel);

    label inertIndex = -1;
    volScalarField Yt("Yt", 0.0*Yfuel[0]);

    for (label i = 0; i < Yfuel.size(); i++)
    {
        Info << "    Yfuel[i].name() = " << Yfuel[i].name() << nl;

        if (matFuel.species()[i].name() != matFuel.inertSpecie())
        {
            volScalarField& Yi = Yfuel[i];
            volScalarField& diffFuelS = matFuel.diffusivity()[i];

            fvScalarMatrix YiEqn
            (
                fvm::ddt(eFuel*matFuel.rho(), Yi)
              + yConvection->fvmDiv(eFuelf*phiFuel, Yi)
              - fvm::laplacian(eFuel*matFuel.rho()*diffFuelS, Yi, "laplacian(diff,y)")
            );
            if(i == matFuel.waterIndex()) // vapour to liquid
            {
                YiEqn -= phaseChangeFuel.Svl();
            }
            YiEqn.relax();
            YiEqn.solve(fuelMesh.solverDict("Yi"));

            //Yi.max(0.0);
            Yi.max(Foam::doubleScalarSMALL);
            Yt += Yi;
        }
        else
        {
            inertIndex = i;
        }
    }

    Info<< "inertIndex = " << inertIndex << nl;
    Yfuel[inertIndex] = scalar(1) - Yt;
    Yfuel[inertIndex].correctBoundaryConditions();
    Yfuel[inertIndex].max(Foam::doubleScalarSMALL);

    forAll(Yfuel, i)
    {
        //lim.limit(Yfuel[i], 0, 1, true); // limit to values between 0 and 1
	lim.check(Yfuel[i], 0, 1);
    }
    matFuel.updateMoleFractions();
}
