    Info<< "Reading air fields" << endl;
    volScalarField pAir
    (
        IOobject
        (
            "p",
            runTime.timeName(),
            airMesh,
            IOobject::READ_IF_PRESENT,
            IOobject::AUTO_WRITE
        ),
        airMesh,
        dimensionedScalar("p", dimPressure, 0)
    );

    volScalarField pdAir
    (
        IOobject
        (
            "pd",
            runTime.timeName(),
            airMesh,
            IOobject::MUST_READ,
            IOobject::AUTO_WRITE
        ),
        airMesh
    );
    lim.checkRelax(pdAir);

    volScalarField nuAir
    (
        IOobject
        (
            "nu",
            runTime.timeName(),
            airMesh,
            IOobject::READ_IF_PRESENT,
            IOobject::AUTO_WRITE
        ),
        airMesh,
        dimensionedScalar("nu",dimensionSet(0,2,-1,0,0,0,0), 0),
        zeroGradientFvPatchScalarField::typeName
    );

    volVectorField Uair
    (
        IOobject
        (
            "U",
            runTime.timeName(),
            airMesh,
            IOobject::MUST_READ,
            IOobject::AUTO_WRITE
        ),
        airMesh
    );
    lim.checkRelax(Uair);

    // inverse matrix diagonal field rUA
    volScalarField rUAair
    (
        IOobject
        (
            "(1|A(U))",
            runTime.timeName(),
            airMesh
        ),
        airMesh,
        dimensionedScalar("rUA", dimTime/dimDensity, 1),
        zeroGradientFvPatchScalarField::typeName
    );

    // Pressure reference point in air
    label pAirRefCell = 0;
    scalar pAirRefValue = 0.0;

    setRefCell
    (
        pAir,
	pdAir,
        airMesh.solutionDict().subDict("PISO"),
        pAirRefCell,
        pAirRefValue
    );

    airMesh.setFluxRequired(pdAir.name());

    volScalarField Tair
    (
        IOobject
        (
            "T",
            runTime.timeName(),
            airMesh,
            IOobject::READ_IF_PRESENT,
            IOobject::AUTO_WRITE
        ),
        airMesh,
        Tref,
        zeroGradientFvPatchScalarField::typeName
    );

    volScalarField sAir
    (
        IOobject
        (
            "s",
            runTime.timeName(),
            airMesh,
            IOobject::MUST_READ,
            IOobject::AUTO_WRITE
        ),
        airMesh
    );
    lim.checkRelax(sAir);

    IOdictionary airProperties
    (
        IOobject
        (
            "phaseProperties",
            runTime.constant(),
            airMesh,
            IOobject::MUST_READ,
            IOobject::NO_WRITE
        )
    );

    dimensionedScalar rhoA("rho", dimDensity, airProperties);
    Info<< "Air reference density: " << rhoA << endl;

    Info<< "Creating air face flux field phi" << endl;
    surfaceScalarField phiAir
    (
        IOobject
        (
            "phi",
            runTime.timeName(),
            airMesh,
            IOobject::READ_IF_PRESENT,
            IOobject::AUTO_WRITE
        ),
        linearInterpolate(rhoA*Uair) & airMesh.Sf()
    );

    volScalarField ghAir("gh", (g & airMesh.C()) );
    surfaceScalarField ghfAir("ghf", (g & airMesh.Cf()));

    // Force p_rgh to be consistent with p
    pAir = pdAir + rhoA*ghAir;

    IOdictionary airSpeciesDict
    (
        IOobject
        (
            "phaseProperties",
            airMesh.time().constant(),
            airMesh,
            IOobject::MUST_READ,
            IOobject::NO_WRITE
        )
    );

    const speciesTable airSpeciesNames(airSpeciesDict.lookup("species"));

    // mass fraction fields and files
    // ------------------------------
    multivariateSurfaceInterpolationScheme<scalar>::fieldTable airYs;
    PtrList<volScalarField> Yair(airSpeciesNames.size());

    forAll(airSpeciesNames, i)
    {
        Yair.set
        (
            i,
            new volScalarField
            (
                IOobject
                (
                    "Y" + airSpeciesNames[i],
                    runTime.timeName(),
                    airMesh,
                    IOobject::MUST_READ,
                    IOobject::AUTO_WRITE
                ),
                airMesh
            )
        );
        airYs.add(Yair[i]);
        lim.checkRelax(Yair[i]);
    }

    materialDatabase matAir(Yair, Tair, Uair, pAir, sAir);

    // activation terms
    // ------------------------------
    autoPtr<activationOverpotentialModel> airActivationOverpotential
    (
        activationOverpotentialModel::New(airSpeciesNames, airSpeciesDict.subDict("activationParameters"))
    );
