    Info << "Reading cell field T\n" << endl;
    volScalarField Tcell
    (
        IOobject
        (
            "T",
            runTime.timeName(),
            mesh,
            IOobject::MUST_READ,
            IOobject::AUTO_WRITE
        ),
        mesh
    );

    volScalarField TCcell
    (
        IOobject
        (
            "TC",
            runTime.timeName(),
            mesh,
            IOobject::READ_IF_PRESENT,
            IOobject::AUTO_WRITE
        ),
        mesh,
        dimensionedScalar("T", dimTemperature, 0)
    );

    volScalarField rhoCpCell
    (
        IOobject
        (
            "rhoCp",
            runTime.timeName(),
            mesh,
            IOobject::READ_IF_PRESENT,
            IOobject::NO_WRITE
        ),
        mesh,
        dimensionedScalar("rc", dimDensity*dimSpecificHeatCapacity, 0),
        zeroGradientFvPatchScalarField::typeName
    );

    volScalarField kCell
    (
        IOobject
        (
            "k",
            runTime.timeName(),
            mesh,
            IOobject::MUST_READ,
            IOobject::AUTO_WRITE
        ),
        mesh
    );

    surfaceScalarField phiCell
    (
        IOobject
        (
            "phi",
            runTime.timeName(),
            mesh,
            IOobject::NO_READ,
            IOobject::NO_WRITE
        ),
        mesh,
        dimensionedScalar
        (
            "rp",
            dimVelocity*dimArea,
            0
        )
    );

    surfaceScalarField eRhoCpPhiCell
    (
        IOobject
        (
            "eRhoCpPhi",
            runTime.timeName(),
            mesh,
            IOobject::NO_READ,
            IOobject::NO_WRITE
        ),
        mesh,
        dimensionedScalar
        (
            "rp",
            dimVelocity*dimDensity*dimSpecificHeatCapacity*dimArea,
            0
        )
    );

    // Volumetric heat source
    volScalarField TsourceCell
    (
        IOobject
        (
            "Tsource",
            runTime.timeName(),
            mesh,
            IOobject::READ_IF_PRESENT,
            IOobject::AUTO_WRITE
        ),
        mesh,
        dimensionedScalar("ts", dimensionSet(1, -1, -3, 0, 0, 0, 0), 0)
    );

    #include "readGravitationalAcceleration.H"

    // heat of condensation
    volScalarField hCond
    (
        IOobject
        (
            "hCond",
            runTime.timeName(),
            mesh,
            IOobject::NO_READ,
            IOobject::NO_WRITE
        ),
        mesh,
        dimensionedScalar("rc", dimensionSet(0,2,-2,0,0,0,0), 0),
        zeroGradientFvPatchScalarField::typeName
    );

    // phase change (source term vapour-liquid)
    volScalarField SvlCell
    (
        IOobject
        (
            "Svl",
            runTime.timeName(),
            mesh,
            IOobject::READ_IF_PRESENT,
            IOobject::AUTO_WRITE
        ),
        mesh,
        dimensionedScalar("0", dimensionSet(1,-3,-1,0,0,0,0), 0),
        zeroGradientFvPatchScalarField::typeName
    );

    surfaceScalarField rhoCpGCell
    (
        IOobject
        (
            "rhoCpG",
            runTime.timeName(),
            mesh,
            IOobject::NO_READ,
            IOobject::NO_WRITE
        ),
        mesh,
        dimensionedScalar
        (
            "rp",
            dimVelocity*dimDensity*dimSpecificHeatCapacity*dimArea,
            0
        )
    );
