    Info<< nl << "Creating fuel fields" << endl;
    volScalarField pFuel
    (
        IOobject
        (
            "p",
            runTime.timeName(),
            fuelMesh,
            IOobject::READ_IF_PRESENT,
            IOobject::AUTO_WRITE
        ),
        fuelMesh,
        dimensionedScalar("p", dimPressure, 0)
    );

    volScalarField pdFuel
    (
        IOobject
        (
            "pd",
            runTime.timeName(),
            fuelMesh,
            IOobject::MUST_READ,
            IOobject::AUTO_WRITE
        ),
        fuelMesh
    );
    lim.checkRelax(pdFuel);

    volScalarField nuFuel
    (
        IOobject
        (
            "nu",
            runTime.timeName(),
            fuelMesh,
            IOobject::READ_IF_PRESENT,
            IOobject::AUTO_WRITE
        ),
        fuelMesh,
        dimensionedScalar("nu",dimensionSet(0,2,-1,0,0,0,0), 0),
        zeroGradientFvPatchScalarField::typeName
    );

    volVectorField Ufuel
    (
        IOobject
        (
            "U",
            runTime.timeName(),
            fuelMesh,
            IOobject::MUST_READ,
            IOobject::AUTO_WRITE
        ),
        fuelMesh
    );
    lim.checkRelax(Ufuel);

    // inverse matrix diagonal field rUA
    volScalarField rUAfuel
    (
        IOobject
        (
            "(1|A(U))",
            runTime.timeName(),
            fuelMesh
        ),
        fuelMesh,
        dimensionedScalar("rUA", dimTime/dimDensity, 1),
        zeroGradientFvPatchScalarField::typeName
    );

    // Pressure reference point in fuel
    label pFuelRefCell = 0;
    scalar pFuelRefValue = 0.0;

    setRefCell
    (
        pFuel,
        pdFuel,
	fuelMesh.solutionDict().subDict("PISO"),
        pFuelRefCell,
        pFuelRefValue
    );

    fuelMesh.setFluxRequired(pdFuel.name());

    volScalarField Tfuel
    (
        IOobject
        (
            "T",
            runTime.timeName(),
            fuelMesh,
            IOobject::READ_IF_PRESENT,
            IOobject::AUTO_WRITE
        ),
        fuelMesh,
        Tref,
        zeroGradientFvPatchScalarField::typeName
    );

    volScalarField sFuel
    (
        IOobject
        (
            "s",
            runTime.timeName(),
            fuelMesh,
            IOobject::MUST_READ,
            IOobject::AUTO_WRITE
        ),
        fuelMesh
    );
    lim.checkRelax(sFuel);

    IOdictionary fuelProperties
    (
        IOobject
        (
            "phaseProperties",
            runTime.constant(),
            fuelMesh,
            IOobject::MUST_READ,
            IOobject::NO_WRITE
        )
    );

    dimensionedScalar rhoF("rho", dimDensity, fuelProperties);
    Info<< "Fuel reference density: " << rhoF << endl;

    surfaceScalarField phiFuel
    (
        IOobject
        (
            "phi",
            runTime.timeName(),
            fuelMesh,
            IOobject::READ_IF_PRESENT,
            IOobject::AUTO_WRITE
        ),
        linearInterpolate(rhoF*Ufuel) & fuelMesh.Sf()
    );

    volScalarField ghFuel("gh", (g & fuelMesh.C()) );
    surfaceScalarField ghfFuel("ghf", (g & fuelMesh.Cf()));

    // Force p_rgh to be consistent with p
    pFuel = pdFuel + rhoF*ghFuel;

    IOdictionary fuelSpeciesDict
    (
        IOobject
        (
            "phaseProperties",
            fuelMesh.time().constant(),
            fuelMesh,
            IOobject::MUST_READ,
            IOobject::NO_WRITE
        )
    );

    const speciesTable fuelSpeciesNames(fuelSpeciesDict.lookup("species"));

    // mass fraction fields and files
    // ------------------------------
    multivariateSurfaceInterpolationScheme<scalar>::fieldTable fuelYs;
    PtrList<volScalarField> Yfuel(fuelSpeciesNames.size());

    forAll(fuelSpeciesNames, i)
    {
        Yfuel.set
        (
            i,
            new volScalarField
            (
                IOobject
                (
                    "Y" + fuelSpeciesNames[i],
                    runTime.timeName(),
                    fuelMesh,
                    IOobject::MUST_READ,
                    IOobject::AUTO_WRITE
                ),
                fuelMesh
            )
        );
        fuelYs.add(Yfuel[i]);
        lim.checkRelax(Yfuel[i]);
    }

    materialDatabase matFuel(Yfuel, Tfuel, Ufuel, pFuel, sFuel);

    // activation terms
    // ------------------------------
    autoPtr<activationOverpotentialModel> fuelActivationOverpotential
    (
        activationOverpotentialModel::New(fuelSpeciesNames, fuelSpeciesDict.subDict("activationParameters"))
    );
