{
    Info << nl << "Solving energy equation" << endl;

    // compute heat of condensation
    hCond = 
	dimensionedScalar("0", dimensionSet(0,2,-2,-1,0,0,0), -2438.5)*Tcell 
      + dimensionedScalar("0", dimensionSet(0,2,-2,0,0,0,0), 3170700.);
    lim.check(hCond, -GREAT, GREAT);
    lim.check(kCell, 0, GREAT,false); // should never be negative

    while (pimple.correctNonOrthogonal())
    {
        fvScalarMatrix TcellEqn
        (
            fvm::div(eRhoCpPhiCell, Tcell)
          + fvm::div(rhoCpGCell, Tcell)
          + fvm::SuSp(-fvc::div(eRhoCpPhiCell), Tcell)
          - fvm::laplacian(kCell, Tcell)
          - TsourceCell
          + SvlCell*hCond
        );
        // Apply under-relaxation: not allowed
        // Under-relaxation in solid conduction (which dominates) creates a large
        // thermal inertia.  HJ
	TcellEqn.relax();
        TcellEqn.solve();
    }

    // limit temperature
    lim.limit(Tcell, Tref.value() - Tlim.value(), Tref.value() + Tlim.value(), false);

    TCcell = Tcell - dimensionedScalar("0", dimTemperature, 273.15); // temperature in °C

    lim.check(Tcell, Tref.value(), Tref.value() + Tlim.value(), false);
    lim.check(TCcell, Tref.value() - 273.15, Tref.value() - 273.15 + Tlim.value(), false);

    Info << endl;
}
