/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright held by original author
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM; if not, write to the Free Software Foundation,
    Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Class
    Foam::bTime

Description
    Modified Time class. Provides the method setOutputTime(),
    which can be called at the beginning of the solver.

    If the solver is stopped with writeNow() it writes e.g. at time 1.232334.
    When the simulation continues, and the solver should write e.g. each second, 
    then setOutputTime() makes sure that the next written time step is 2, and 
    not 2.232334.

\*---------------------------------------------------------------------------*/

#include "Time.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //
namespace Foam
{
/*---------------------------------------------------------------------------*\
                             Class Time Declaration
\*---------------------------------------------------------------------------*/

class bTime
:
    public Time
{
public:
   // Constructor
        bTime
        (
            const word& name,
            const argList& args,
            const word& systemName = "system",
            const word& constantName = "constant"
        );


   // Member functions

       bool setOutputTime();
       bool printInfos();
};
}
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //


Foam::bTime::bTime
(
    const word& controlDictName,
    const argList& args,
    const word& systemName,
    const word& constantName
)
:
    Foam::Time::Time
    (
        controlDictName,
        args,
        systemName,
        constantName
    )
{}

// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

// es wird nur die startTime geändert!
bool Foam::bTime::setOutputTime()
{
        double a = value();
        a /= writeInterval_;
        a = floor(a);
        a *= writeInterval_;
	startTime_ = a;
    return 0;
}

bool Foam::bTime::printInfos()
{
    Info << "Starttime = " << startTime_ << endl;
    Info << "wrIntervall= " << writeInterval_ << endl;
    Info << value() << endl;
    return 0;
}
// ************************************************************************* //
