/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright held by original author
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM; if not, write to the Free Software Foundation,
    Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

\*---------------------------------------------------------------------------*/

#include "fuelCellSpecies.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

inline fuelCellSpecies::fuelCellSpecies
(
    const scalar molWeight,
    const scalar nElectrons,
    const label rSign,
    const scalar hForm,
    const scalar sForm
)
:
    molWeight_(molWeight),
    nElectrons_(nElectrons),
    rSign_(rSign),
    hForm_(hForm),
    sForm_(sForm)
{}


inline fuelCellSpecies::fuelCellSpecies
(
    const word& name,
    const scalar molWeight,
    const scalar nElectrons,
    const label rSign,
    const scalar hForm,
    const scalar sForm
)
:
    name_(name),
    molWeight_(molWeight),
    nElectrons_(nElectrons),
    rSign_(rSign),
    hForm_(hForm),
    sForm_(sForm)
{}


inline fuelCellSpecies::fuelCellSpecies(const fuelCellSpecies& st)
:
    name_(st.name_),
    molWeight_(st.molWeight_),
    nElectrons_(st.nElectrons_),
    rSign_(st.rSign_),
    hForm_(st.hForm_),
    sForm_(st.sForm_)
{}


inline fuelCellSpecies::fuelCellSpecies(const word& name, const fuelCellSpecies& st)
:
    name_(name),
    molWeight_(st.molWeight_),
    nElectrons_(st.nElectrons_),
    rSign_(st.rSign_),
    hForm_(st.hForm_),
    sForm_(st.sForm_)
{}


inline Foam::autoPtr<fuelCellSpecies>
Foam::fuelCellSpecies::clone() const
{
    return autoPtr<fuelCellSpecies>
    (
        new fuelCellSpecies(*this)
    );
}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

inline word fuelCellSpecies::name() const
{
    return name_;
}

inline scalar fuelCellSpecies::MW() const
{
    return molWeight_;
}

inline scalar fuelCellSpecies::ne() const
{
    return nElectrons_;
}

inline label fuelCellSpecies::rSign() const
{
    return rSign_;
}

inline scalar fuelCellSpecies::hForm() const
{
    return hForm_;
}

inline scalar fuelCellSpecies::sForm() const
{
    return sForm_;
}


// * * * * * * * * * * * * * * * Member Operators  * * * * * * * * * * * * * //

inline void fuelCellSpecies::operator=(const fuelCellSpecies& st)
{
    name_ = st.name_;
    molWeight_ = st.molWeight_;
    nElectrons_ = st.nElectrons_;
    rSign_ = st.rSign_;
    hForm_ = st.hForm_;
    sForm_ = st.sForm_;
}

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// ************************************************************************* //
