/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright held by original author
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM; if not, write to the Free Software Foundation,
    Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Class
    Foam::materialDatabase

Description
    Provides material properties of a gas.

\*---------------------------------------------------------------------------*/

{    
    // toddYoung polynomials
    // from Todd&Young, J. Power Sources 110 (2002) pp 186-200

    // molar Cp polynomials
    const dictionary& tyDictCp = speciesDict_.subDict("CpCoeffs");
    forAll(species_, i)
    {
        polyToddYoung tmp(tyDictCp.lookup(species_[i].name()));
        molarCp_.set
        (
            i,
            new polyToddYoung(tmp)
        );
        Info<< "    CpCoeffs(" << species_[i].name() << ") ";
        molarCp_[i].writeData();
    }
    Info<< endl;

    // mu polynomials
    const dictionary& tyDictMu = speciesDict_.subDict("muCoeffs");
    forAll(species_, i)
    {
        polyToddYoung tmp(tyDictMu.lookup(species_[i].name()));
        muS_.set
        (
            i,
            new polyToddYoung(tmp)
        );
        Info<< "    muCoeffs(" << species_[i].name() << ") ";
        muS_[i].writeData();
    }
    Info<< endl;

    // k polynomials
    const dictionary& tyDictK = speciesDict_.subDict("kCoeffs");
    forAll(species_, i)
    {
        polyToddYoung tmp(tyDictK.lookup(species_[i].name()));
        kS_.set
        (
            i,
            new polyToddYoung(tmp)
        );
        Info<< "    kCoeffs(" << species_[i].name() << ") ";
        kS_[i].writeData();
    }
    Info<< endl;

    Info<< "    ToddYoung checks" << nl;
    forAll(species_, i)
    {
        Info<< "    " << species_[i].name() << nl;
        Info<< "        Cp(1473) = " << molarCp_[i].polyVal(1473) << nl;
        Info<< "        mu(1473) = " << muS_[i].polyVal(1473) << nl;
        Info<< "        k(1473)  = " << kS_[i].polyVal(1473) << nl;
    }
    Info<< nl;

    // diffusivity fields and files
    // ------------------------------
    forAll(species_, i)
    {
        diffSp_.set
        (
            i,
            new volScalarField
            (
                IOobject
                (
                    "diff" + species_[i].name(),
                    mesh_.time().timeName(),
                    mesh_,
                    IOobject::READ_IF_PRESENT,
                    IOobject::AUTO_WRITE
                ),
                mesh_,
                dimensionedScalar("d", dimensionSet(0,2,-1,0,0,0,0), 1.0),
                zeroGradientFvPatchScalarField::typeName
            )
        );
    }
}

// ************************************************************************* //
