/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright held by original author
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM; if not, write to the Free Software Foundation,
    Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Class
    Foam::ohmicOverpotentialModel

Description
    Area specific resistance computed according to springer model.

    Reference:
    \verbatim
        Springer, T. E., Zawodinski, T. A., Gottesfeld, S. (1991)
	Polymer Electrolyte Fuel Cell Model.
	J. Electrochem. Soc. 138(8), 2334-2342.
    \endverbatim

\*---------------------------------------------------------------------------*/

#ifndef springer_H
#define springer_H

#include "ohmicOverpotentialModel.H"
#include "checkFieldLimits.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                           Class springer Declaration
\*---------------------------------------------------------------------------*/

class springer
:
    public ohmicOverpotentialModel,
    private checkFieldLimits
{
    // Private data
	//- Correction factor for conductivity
	scalar correctSigma_;
	//- Area specific contact resistance
	dimensionedScalar contactResistance_;


   // Private member functions

        //- Disallow copy construct
        springer(const springer&);

        //- Disallow default bitwise assignment
        void operator=(const springer&);


public:

    //- Runtime type information
    TypeName("springer");


    // Constructors

        springer
        (
            const fvMesh& mesh,
            const patchDatabase& pm,
            const dictionary& dict
        );


    // Destructor

        ~springer()
        {}


    // Member functions

        //- Returns area specific resistance
        virtual tmp<scalarField> ASR
        (
            const scalarField& T,
            const scalarField& lambda
        ) const;
};

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
