/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright held by original author
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::solidZone

Description
    Top level model for solid zones. Provides the properties of these
    solid zones.

\*---------------------------------------------------------------------------*/

inline const Foam::labelList& Foam::solidZone::zoneIds() const
{
    return cellZoneIDs_;
}
inline const Foam::keyType& Foam::solidZone::zoneName() const
{
    return zoneName_;
}
inline Foam::dimensionedScalar Foam::solidZone::k() const
{
    return k_;
}
inline Foam::dimensionedScalar Foam::solidZone::cp() const
{
    return cp_;
}
inline Foam::dimensionedScalar Foam::solidZone::rho() const
{
    return rho_;
}
