# OpenFOAM-extensions

This file will guide you through the instalation process of the
"OpenFOAM-extensions" library that was presented to the OpenFOAM Journal with
the article entitled "Modular framework for the solution of boundary-coupled
multiphysics problems".

Required software:

    - OpenFOAM v2006 (Go to:
      "https://www.openfoam.com/news/main-news/openfoam-v20-06" to download
      binary or source code.)
    - HiSA (Go to: "https://gitlab.com/hisa/hisa" to download source code. The
      code was tested using the master branch at commit 538736bf)
    - OpenFOAM-extensions
    - Paraview (https://www.paraview.org/)
    - GMSH (For ubuntu users: "sudo apt install gmsh" to download. For others:
      https://gmsh.info/)


Make sure that all OpenFOAM libraries are in the same folder. Also, the folder
containing the hisa library must be named "hisa". The OpenFOAM file tree should
look like this:

```
~/OpenFOAM/
      |-- hisa/
      |-- OpenFOAM-extensions/
```

The OpenFOAM installation may be local (typically in the ~/OpenFOAM folder) or
system wide (e.g., installed with a binary package). In the latter case, make
sure you have installed the systems requirements to compile code.

Before the compilation steps, the following line must be added to the end of
the  "~/.bashrc" file:

    source ~/OpenFOAM/OpenFOAM-extensions/etc/bashrc

Compilation steps:

1. If not done yet, compile or install OpenFOAM v2006.
2. Compile the hisa library with the provided "Allwmake" script.
3. Compile the OpenFOAM-extensions library:
    - use the alias "ext" in the terminal to move to the correct location.
    - launch the compilation process with the "./Allwmake" script.

The OpenFOAM-extensions library should now be compiled and ready to use! 

The folder "./OpenFOAM-extensions/tutorials/" contains all three test cases
that are discussed in the paper.
