# Heated Cylinder

This simulation represents the case of a hypersonic flow around a cylinder. The
aerodynamic heating of the fluid interacts with the cylinder.

Two types of interface boundary conditions are tested. The Dirichlet-Neumann
boundary conditions combintation is used in the case "DirichletNeumann", while
mixed boundary conditions used for the case "mixed".

Requirements:

    - HiSA
    - OpenFOAM-extensions

To run a simulation, launch the "Allrun" script present in each simulation
folder. To clean the simulation folder, use the "Allclean" script. To open the
simulation in paraview, use the "paraFoam" command or load the .foam file.

The user may want to adjust the Courant number for the simulations or the
number of processors for parallel computing.  To do so, the user can access the
file "./system/include/CaseControl" and chage the "MaxCourantNo" parameters.
Similarly, the user can access the same file to change the "nProcess"
parameters.

More details on this simulation are provided in section 3.2 of the article
entitled "Modular framework for the solution of boundary-coupled multiphysics
problems". Specifically, the two cases where used to produce figure 9 The cold
wall can be reproduced at a time of 0.0002 s, and the hot wall results at a
time of 0.0012 s. Also, raw data to create figure 9 are included in a zip file.

Each simulation took a little over 3 hours to complete on an Intel i7-7700 HQ
CPU using 4 cores.
