# Flexible Tube

This simulation represents the case of flow driven by a pressure pulse within a
flexible tube.  Two types of boundary conditions are used for this particular
case. The step total pressure boundary condition is used for the simulation
contained in the "Step" folder while the smooth total pressure boundary
condition is used for the simulation contained in the "Smooth" folder.

Requirements:

    - GMSH
    - OpenFOAM-extensions
    - Compile special boundary condition ("smoothPulseTotalPressure" for
      the "Smooth" case and "pulseTotalPressure" for the "Step" case)

To run a simulation, launch the "Allrun" script present in each simulation
folder.  To clean the simulation folder, use the "Allclean" script.  To open
the simulation in Paraview, use the "paraFoam" command or load the .foam file.

The user may want to adjust the mesh size for a simulation or the number of
processors for parallel computing.  To do so, the user can access the file
"./Add-On/meshes/flexibleTubeParameters.geo" and change the "refinementFactor"
parameter.  Similarly, the user can access the file "./system/NumProcessor" to
change the "NumProcess" parameter.

During the simulation, pressure and flow rate data are extracted and can be
accessed in the postProcessing folder.

More details on this simulation are provided in section 3.1 of the article
entitled "Modular framework for the solution of boundary-coupled multiphysics
problems". The pressure and flow rate data can be used to reproduce results
from figures 6 ("smooth" case) and 7 ("step" case) of the paper. Also, raw 
data to create both figure are included in a zip file. 

Each simulation with the coarse mesh setting (refinement factor of 2) took less
than an hour to complete on an Intel i7-7700 HQ CPU using 4 cores.
