# Data appendix for the OpenFOAM-preCICE paper

You can find here all setup files used in the paper "OpenFOAM–preCICE: Coupling OpenFOAM with external solvers for multi-physics
simulations":

- partitioned-heat-conduction: refers to the computations of section 7.1
- flow-over-heated-plate: refers to the computations of section 7.2
- turek-hron-fsi: refers to the computations of section 7.3
- pulsating-flow-over-flexible-flap: refers to the computations of section 7.4

Have a look in the READMEs of each directory for further information. All computations use preCICE version 2.4.0, OpenFOAM v2112, and the OpenFOAM adapter version 1.1.0. In the FSI cases, we are using codes depending on deal.II 9.3.0 as the solid solver (see details in the respective sections).

Note that while the first two cases are easy and quick to run on a laptop, the FSI cases will need significantly more time to run (ideally on a workstation with multiple cores, or on a small cluster).

It is a known issue that OpenFOAM will produce some additional empty result directories for timesteps just before a coupling time window completes. These may be distracting when animating visualizations in ParaView. You can automatically delete such empty directories using the script `openfoam-remove-empty-dirs.sh <path to OpenFOAM case>` from the `tools/` directory.

A reproducible environment with everything already installed is provided as a [Vagrant box](https://app.vagrantup.com/precice/boxes/openfoam-precice-paper-vm) (virtual machine image). This is based on the [preCICE Demo Virtual Machine](https://precice.org/installation-vm.html) (including all other solvers, adapters, and tutorials), the documentation of which still applies. You may want to allocate more CPU cores and RAM, if possible (2 cores and 2GB RAM are set by default). In case you use this environment, skip the steps of installing, building, or copying solvers and other tools (e.g., swak4Foam, ExaDG, or deal.II). These case files are also available in `~/paper-cases/`.
