# Flow over a heated plate

This directory contains:

- `chtMultiRegionFoam`: the (software-wise) monolithic OpenFOAM native CHT solver
- `fluid-openfoam`: OpenFOAM setup for the fluid participant (buoyantPimpleFoam)
- `solid-openfoam`: OpenFOAM setup for the solid participant (laplacianFoam)

These files correspond to the steady-state case. The transient case needs small adjustments, described at the end of this document.

## Running the steady-state case

The steady-state scenario is the default configuration of all setups.

- The chtMultiRegionFoam solver can be executed using the `run.sh` script in the corresponding directory
- The coupled simulation can be started by opening two terminals and running `buoyantPimpleFoam` in the fluid participant directory and `laplacianFoam` in the solid participant directory.

## Post-processing

You can use the postprocessing script `compute_error.sh` to generate the plots and evaluate the error. The script directly parses the temperature result files generated by OpenFOAM (`T`) and launches a Python script that plots the data. The script takes three input arguments: the temperature result file of the monolithic chtMultiRegionFoam, the temperature result file of the solid participant, and the number of interface points to be parsed. The default setup can be processed using the following command:
```bash
./compute_error.sh --coupled solid-openfoam/100/T --monolithic chtMultiRegionFoam/100/solid/T --n-points 32
```

Note that the provided plotting scripts have a slightly different style compared to the plots in the paper. We used `tikzplotlib` in order to convert the generated matplotlib plots into a tikz format and edited style-related details in the resulting tikz file manually. The necessary code lines in order to apply `tikzplozlib` are included in the `compute_errors.py` script as comments (cf line 52).

## Running the transient case

In order to run the serial-explicit coupled transient case, only the end time and the write interval needs to be changed to (t = 1s), in the following files
  - `chtMultiRegionFoam/system/controlDict`
  - `precice-config.xml`: line `<max-time value="1" />`. The write time is steered by OpenFOAM as usual (configured in `system/controlDict`).

The time-step size needs to be changed in the `system/controlDict` (entry `deltaT`) and in the `precice-config.xml` (entry `<time-window-size value="0.01" />`).

This directory also contains a file called `precice-config_implicit.xml` for the implcit coupling. In order to select a different configuration file for the coupled simulation, please modify the configuration file name in `system/preciceDict` entry `preciceConfig`. Note that the default coupling time-window size for the implicit coupling is `4e-4`, which needs to be the same for the solver to couple every time step. The coupling iteration count for the `chtMultiRegionFoam` can be set in the `system/fvSolution` file.
