#!/bin/bash
set -e -u

echo -e "--------------------------------------------------------------------"
# The temperature result file of the coupled simulation (solid participant)
precice_file=""

# The temperature result file of the chtMultiRegionFoam simulation (solid participant)
monolithic_file=""

# The number of interface points
n_interface_points=32

USAGE="Usage: -c (--coupled) the solid-openfoam Temperature result file (e.g. 100/T), -m (--monolithic) the temperature result file of the chtMultiRegionFoam simulation (solid participant), -n (--n-points) the number of interface points (default is 32)."

if [ ${#} -lt 1 ] ; then
    echo "No arguments provided."
    echo "${USAGE}"
    exit 1
fi

while [[ $# -gt 0 ]]; do
	key="$1"

	case $key in
	-c | --coupled)
		precice_file="${2}"
		shift
	 	shift
     	;;
	-m | --monolithic)
		monolithic_file="${2}"
		shift
	 	shift
     	;;
	-n | --n-points)
		n_interface_points="${2}"
		shift
	 	shift
     	;;
     *)
       echo "Unknown option $1"
       echo "${USAGE}"
       exit 1
       ;;
	 *)
		# unknown option
		shift
		;;
	 esac
done

echo  "The solid-openfoam result file is ${precice_file}"
if [ ! -f "${precice_file}" ]; then
    echo "Invalid solid/T file from preCICE"
	exit 1
fi

echo  "The chtMultiRegionFoam result file is ${monolithic_file}"
if [ ! -f "${monolithic_file}" ]; then
    echo "Invalid solid/T file from chtMultiRegionFoam"
	exit 2
fi
echo  "The number of interface points ${n_interface_points}"

# Step 1: generate the raw data files from the given information

# For the coupled simulation we have
precice_tmp_file="precice_tmp_file.solid"
grep -E -A $(("${n_interface_points}"+15)) 'interface' "${precice_file}" > "tempfile"
grep -E -A $(("${n_interface_points}"+15)) 'value ' "tempfile" > "${precice_tmp_file}"
sed -i -n '4,35p' "${precice_tmp_file}"
#grep -E -A $(("${n_interface_points}"+80)) 'solid_to_fluid' "${precice_file}" > "${precice_tmp_file}"
#sed -i -e '1,81d' "${precice_tmp_file}"

# For the chtMultiRegionFoam simulation we have
monolithic_tmp_file="monolithic_tmp_file.solid"
#grep -E -A $(("${n_interface_points}"+5)) 'interface' "${monolithic_file}" > "${monolithic_tmp_file}"
#sed -i -e '1,6d' "${monolithic_tmp_file}"
#monolithic_tmp_file="monolithic_tmp_file.solid"
grep -E -A $(("${n_interface_points}"+120)) 'solid_to_fluid' "${monolithic_file}" > "tempfile"
grep -E -A $(("${n_interface_points}"+120)) 'value '  "tempfile" > "${monolithic_tmp_file}"
sed -n -i '4,35p' "${monolithic_tmp_file}"
rm tempfile

# Step 2: parse the files and compute the error
python3 ./compute_errors.py -c="${precice_tmp_file}" -m="${monolithic_tmp_file}" -n="${n_interface_points}"

# Step 3: remove the tmp files
rm -fv "${precice_tmp_file}" "${monolithic_tmp_file}"

