# Partitioned heat conduction

This directory contains:

- openfoam-dirichlet: the OpenFOAM setup for the coupled Dirichlet participant (cf. Fig. 5)
- openfoam-neumann: the OpenFOAM setup for the coupled Neumann participant (cf. Fig. 5)
- openfoam-solver: the OpenFOAM solver required for all computations of this section
- openfoam-monolithic: the OpenFOAM setup for the monolithic solver without coupling
- the preCICE configuration file (precice-config.xml)

## Dependencies

- swak4Foam: We only need funkySetFields and the groovyBC boundary condition. Follow the [installation instructions](https://openfoamwiki.net/index.php/Contrib/swak4Foam) and make sure you are building a state compatible with your OpenFOAM version. The revision `3977:97def697c76e` from the branch `feature/port/p2112` is known to work with OpenFOAM v2112 and this setup. While the building may fail, this is fine as long as `funkySetFields` and `groovyBC` are generated into `$FOAM_USER_APPBIN` and `$FOAM_USER_LIBBIN`.

## Running the cases

1. Navigate into the `openfoam-solver` directory and compile the solver using the command `wmake`.
2. Each case directory contains a `run.sh` script, which starts the simulation. For the coupled simulation, start the `openfoam-dirichlet` and `openfoam-neumann` participants in two different terminals (e.g., two different `screen` sessions, or start them both in the background from the same terminal).

## Getting the error metrics

The solver will compute error metrics at runtime and print them to the console. Use the information from the last step of each simulation.

The refinement was adjusted (using blockMeshDict) for each node in the plot (cf. Fig. 6). The respective numbers of cells are `(10 10 1)`, `(20 20 1)`, `(40 40 1)`, `(100 100 1)`, `(300 300 1)`, and `(600 600 1)`.

The error metric of `Dirichlet` refers to the `openfoam-dirichlet` participant, `Neumann` to the `openfoam-neumann` participant and `monolithic` to the `openfoam-monolithic` participant. The error metric of the `coupled` plot was computed by summing up the 'absolute error' of `Dirichlet` and `Neumann`, dividing it by the number of DoFs and computing the square root e = sqrt( (e_d + e_n) / n ).

The plot within the article was manually generated using tikz and the six error measurements.
