# Pulsating flow over a flexible flap

This directory contains the case files corresponding to the different spatial resolutions, as described in the paper. The `timings` directory contains slightly altered setup files as well as log files corresponding to the performance measurements shown in the same section of the paper.

## Dependencies

Special requirements:

- Solid solver: A [deal.II-based solver](https://github.com/davidscn/matrix-free-dealii-precice). Follow the [installation instructions](https://github.com/davidscn/matrix-free-dealii-precice#installation). As a summary:
  1. Get the solver with `git clone https://github.com/DavidSCN/matrix-free-dealii-precice.git`
  2. You first need to install deal.II before you can build the solver. In an Ubuntu-based system, [installing the `libdeal.ii-dev` package](https://dealii.org/download.html) (version 9.3) is enough.
  3. Make a build directory, configure the build, and run Make: `mkdir build && cd build && cmake .. && make`.  You will later need to copy the produced `solid` executable.
- swak4Foam: We only need the groovyBC boundary condition. Follow the [installation instructions](https://openfoamwiki.net/index.php/Contrib/swak4Foam) and make sure you are building a state compatible with your OpenFOAM version. The revision `3977:97def697c76e` from the branch `feature/port/p2112` is known to work with OpenFOAM v2112 and this setup. While the building may fail, this is fine as long as `groovyBC` is generated into `$FOAM_USER_LIBBIN`.

## Running the cases

**Note:** These cases will run for several hours, so you may want to avoid running them on your laptop. Adjust the domain decomposition and number of ranks according to the capabilities of your system. While the fluid solver is configured to run on 48 processes, you can also get results in a few hours with much less than that.

- Copy the `solid` executable to the respective `case_?/solid` directory.
- Navigate to the respective `case_?/solid` directory and start the solid solver in one terminal (e.g., one `screen`): `./solid ./bending_flap.prm` or `mpirun -np <N> ./solid ./bending_flap.prm`.
- Navigate to the respective `case_?/fluid` directory and then prepare the mesh with `blockMesh` and decompose the case with `decomposePar`. Set the number of subdomains in `system/decomposeParDict`.
- Start OpenFOAM in another terminal (e.g., another `screen`): `mpirun -np <N> pimpleFoam -parallel`.

If you are running on a cluster using a job script, start both processes in the background. Read more in the [preCICE documentation](https://precice.org/running-slurm.html).

## Post-processing

The relevant output files for this case are the two watchpoint files on the solid side, `precice-Solid-watchpoint-center-front-tip.log` and `precice-Solid-watchpoint-left-back-tip.log`. These watchpoints are CSV files that can be plotted using, e.g., gnuplot:

```bash
gnuplot -p << EOF                                                               
    set grid                                                                        
    set title 'x-displacement of the flap tip center'                                        
    set xlabel 'time [s]'                                                           
    set ylabel 'x-displacement [m]'  
    plot "reference_center.log" using 1:2 with lines title "$1"
EOF
```

Reference results are stored in the top-level case directory in order to compare the results. The reference results were graphically extracted from the plots in the original reference.

In order to generate the displacement plots in the article, we parsed the preCICE watchpoint files directly using tikz.
