# Turek-Hron FSI benchmarks

This directory contains:

- `fsi2`: all configuration files for the FSI2 setup
- `fsi3`: all configuration files for the FSI3 setup

The directories are structured hierarchically, according to the configured time-step size (`small_dt` and `large_dt`) and the spatial mesh refinement (`case_1`, `case_2`, `case_3`), as described in the paper.

## Dependencies

- ExaDG: The framework on which the solid solver is based. Although the coupled solver is part of the project itself, the application-specific changes are usually set in an `application.h` header file. You don't need to modify this file (apart from selecting between FSI2 and FSI3), as we already provide the code for this case in a dedicated branch.

    1. Note that ExaDG itself depends on deal.II (version 9.3.0 and 9.4.0 are known to work, 9.3.2 may not compile). In an Ubuntu-based system, [installing the `libdeal.ii-dev` package](https://dealii.org/download.html) (version 9.3.0, 9.3.3, or 9.4.0) is enough. If you need to build everything from source, note that the default case setup requires to compile deal.II (make sure to compile a released version of deal.II) and ExaDG with Trilinos and p4est. For a complete overview of ExaDG and the installation, have a look at the [ExaDG installation instructions](https://github.com/exadg/exadg/wiki/Installation).

    2. Get the application-specific branch of ExaDG: `git clone --branch fsi-setups  https://github.com/davidscn/exadg.git`. Afterwards, create a build directory and configure the build with CMake:
    ```bash
    mkdir build && cd build && cmake -D EXADG_WITH_PRECICE="ON" -D CMAKE_BUILD_TYPE="Release" ..
    ```

    3. You don't need to compile the complete ExaDG project to run this case. You can save time by building only the specific solver we need. Navigate into `build/applications/fluid_structure_interaction/cylinder_with_flag/` and build using Make:
    ```bash
    cd applications/fluid_structure_interaction/cylinder_with_flag/ && make
    ```
    This will generate the executable `solver_precice`, which you will need to copy to specific directories later. Consider using `make -j <N>`, depending on the available resources.

    4. By default, `solver_precice` will be built for the FSI2 setup, as it includes hard-coded boundary conditions. Switch from FSI2 to FSI3 using the preprocessor flag in [line 30 of `exadg/applications/fluid_structure_interaction/cylinder_with_flag/application.h`](https://github.com/DavidSCN/exadg/blob/4c5934fd16e433c5fdd07d64d47beb4559bfcbbb/applications/fluid_structure_interaction/cylinder_with_flag/application.h#L30). The default `#define TESTCASE 2` indicates the FSI2 setup, setting it to `#define TESTCASE 3` would configure the FSI3 setup. Using the wrong solid setup will start the simulation, but eventually lead to numerical issues and crash. The end time is also hard-coded in the solver (and needs to be the same as the end time defined in the preCICE configuration file).

- swak4Foam: We only need the groovyBC boundary condition. Follow the [installation instructions](https://openfoamwiki.net/index.php/Contrib/swak4Foam) and make sure you are building a state compatible with your OpenFOAM version. The revision `3977:97def697c76e` from the branch `feature/port/p2112` is known to work with OpenFOAM v2112 and this setup. While the building may fail, this is fine as long as `groovyBC` is generated into `$FOAM_USER_LIBBIN`.

## Running the cases

**Note:** These cases will run for several hours, so you may want to avoid running them on your laptop. Adjust the domain decomposition and number of ranks according to the capabilities of your system. By default, the fluid solver is configured to run on four processes and the solid solver on one process.

1. Copy the `solver_precice` solver (adjusted for FSI2 or FSI3) into the `solid-exadg` directory of the respective case.
2. In the case directory, start the included `./run.sh` script. This is a link to a common run script, which executes both solvers and a few additional steps:
    1. Generates the mesh
    2. Decomposes the case (configure the number of processes here and in the `fluid-openfoam/system/decomposeParDict`)
    3. Precomputes the flow field for the first 2s, running an uncoupled simulation.
    4. Restarts OpenFOAM from t=2s and starts the solid solver, both coupled with preCICE.

Precomputing the flow field is important to stabilize the simulation. An alternative approach is ramping up the inlet velocity. If you prefer this approach, you can modify the time condition in `fluid/0/U`.

## Postprocessing the cases

The results included in the paper are produced using the `fsi2/postProcess.py` and `fsi3/postProcess.py` scripts (which depend on SciPy: `pip3 install scipy`).

Wait till the simulation completes and copy the following files to the same directory as the post-processing script:

- `fluid-openfoam/postProcessing/forces/2/force.dat`: Forces computed by OpenFOAM
- `solid-exadg/precice-Solid-watchpoint-Flap-Tip.log`: preCICE watchpoint, which includes the displacements computed by the Solid.

Then, start the post-processing script as, e.g., `python3 ./postPorcess.py`. After each figure is produced (with the purpose of visually checking that the data and the script are technically right), close the figure window to continue the script execution.

**Note:** Some parameters are hard-coded at the end of these scripts. In particular, you need to adjust the `time_step_size` with the one used in the simulation. This is used to compute the frequency, among other results.

Note that the provided plotting scripts have a slightly different style compared to the plots in the paper. We used `tikzplotlib` in order to convert the generated matplotlib plots into a tikz format and edited style-related details in the resulting tikz file manually. The necessary code lines in order to apply `tikzplozlib` are included in the `compute_errors.py` script as comments (cf line 41).
