#!/bin/bash
set -e


cd ./fluid-openfoam

# First, precompute flow field
cp system/controlDict system/controlDict_coupled

# Remove the adapter
sed -i '/preCICE/,+4 d' system/controlDict
# Set new end time
sed -i '/endTime\ /c\endTime\ 2;' system/controlDict

solver=pimpleFoam
procs=4

blockMesh
decomposePar -force

mpirun -np "${procs}" "${solver}" -parallel

mv system/controlDict_coupled system/controlDict

# Set new start time
sed -i '/startTime\ /c\startTime\ 2;' system/controlDict

# Start the coupled case

mpirun -np "${procs}" "${solver}" -parallel &> fluid.log &

cd ../solid-exadg/ && ./solver_precice input.json

