# trace generated using paraview version 5.11.0-RC1
#import paraview
#paraview.compatibility.major = 5
#paraview.compatibility.minor = 11

#### import the simple module from the paraview
from paraview.simple import *
import numpy as np
#### disable automatic camera reset on 'Show'
paraview.simple._DisableFirstRenderCameraReset()

from pathlib import Path

#### disable automatic camera reset on 'Show'
paraview.simple._DisableFirstRenderCameraReset()

folder_path = Path(r'D:\OpenFOAM_Sims\PhD_Work\force_Cp_graphs')

files = list(folder_path.glob('**/*.foam'))

for file in files:
    # create a new 'OpenFOAMReader'
    anguilliformfoam = OpenFOAMReader(registrationName='anguilliform.foam', FileName=str(file))
    anguilliformfoam.MeshRegions = ['internalMesh']
    anguilliformfoam.CellArrays = ['H', 'HbyA', 'U', 'cellTypes', 'k', 'nut', 'omega', 'p', 'rAU', 'zoneID']

    # get animation scene
    animationScene1 = GetAnimationScene()

    # get the time-keeper
    timeKeeper1 = GetTimeKeeper()

    # update animation scene based on data timesteps
    animationScene1.UpdateAnimationUsingDataTimeSteps()

    # Properties modified on anguilliformfoam
    anguilliformfoam.MeshRegions = ['patch/wingBottom', 'patch/wingTop']

    # get active view
    renderView1 = GetActiveViewOrCreate('RenderView')

    # show data in view
    anguilliformfoamDisplay = Show(anguilliformfoam, renderView1, 'GeometryRepresentation')

    # get color transfer function/color map for 'p'
    pLUT = GetColorTransferFunction('p')

    # trace defaults for the display properties.
    anguilliformfoamDisplay.Representation = 'Surface'
    anguilliformfoamDisplay.ColorArrayName = ['POINTS', 'p']
    anguilliformfoamDisplay.LookupTable = pLUT
    anguilliformfoamDisplay.SelectTCoordArray = 'None'
    anguilliformfoamDisplay.SelectNormalArray = 'None'
    anguilliformfoamDisplay.SelectTangentArray = 'None'
    anguilliformfoamDisplay.OSPRayScaleArray = 'p'
    anguilliformfoamDisplay.OSPRayScaleFunction = 'PiecewiseFunction'
    anguilliformfoamDisplay.SelectOrientationVectors = 'U'
    anguilliformfoamDisplay.ScaleFactor = 0.1
    anguilliformfoamDisplay.SelectScaleArray = 'p'
    anguilliformfoamDisplay.GlyphType = 'Arrow'
    anguilliformfoamDisplay.GlyphTableIndexArray = 'p'
    anguilliformfoamDisplay.GaussianRadius = 0.005
    anguilliformfoamDisplay.SetScaleArray = ['POINTS', 'p']
    anguilliformfoamDisplay.ScaleTransferFunction = 'PiecewiseFunction'
    anguilliformfoamDisplay.OpacityArray = ['POINTS', 'p']
    anguilliformfoamDisplay.OpacityTransferFunction = 'PiecewiseFunction'
    anguilliformfoamDisplay.DataAxesGrid = 'GridAxesRepresentation'
    anguilliformfoamDisplay.PolarAxes = 'PolarAxesRepresentation'
    anguilliformfoamDisplay.SelectInputVectors = ['POINTS', 'U']
    anguilliformfoamDisplay.WriteLog = ''

    # init the 'PiecewiseFunction' selected for 'ScaleTransferFunction'
    anguilliformfoamDisplay.ScaleTransferFunction.Points = [-1.0382322072982788, 0.0, 0.5, 0.0, 0.3021395206451416, 1.0, 0.5, 0.0]

    # init the 'PiecewiseFunction' selected for 'OpacityTransferFunction'
    anguilliformfoamDisplay.OpacityTransferFunction.Points = [-1.0382322072982788, 0.0, 0.5, 0.0, 0.3021395206451416, 1.0, 0.5, 0.0]

    # reset view to fit data
    renderView1.ResetCamera(False)

    # get the material library
    materialLibrary1 = GetMaterialLibrary()

    # show color bar/color legend
    anguilliformfoamDisplay.SetScalarBarVisibility(renderView1, True)

    # update the view to ensure updated data information
    renderView1.Update()

    # get opacity transfer function/opacity map for 'p'
    pPWF = GetOpacityTransferFunction('p')

    # get 2D transfer function for 'p'
    pTF2D = GetTransferFunction2D('p')

    # create a new 'Extract Surface'
    extractSurface1 = ExtractSurface(registrationName='ExtractSurface1', Input=anguilliformfoam)

    # show data in view
    extractSurface1Display = Show(extractSurface1, renderView1, 'GeometryRepresentation')

    # trace defaults for the display properties.
    extractSurface1Display.Representation = 'Surface'
    extractSurface1Display.ColorArrayName = ['POINTS', 'p']
    extractSurface1Display.LookupTable = pLUT
    extractSurface1Display.SelectTCoordArray = 'None'
    extractSurface1Display.SelectNormalArray = 'None'
    extractSurface1Display.SelectTangentArray = 'None'
    extractSurface1Display.OSPRayScaleArray = 'p'
    extractSurface1Display.OSPRayScaleFunction = 'PiecewiseFunction'
    extractSurface1Display.SelectOrientationVectors = 'U'
    extractSurface1Display.ScaleFactor = 0.1
    extractSurface1Display.SelectScaleArray = 'p'
    extractSurface1Display.GlyphType = 'Arrow'
    extractSurface1Display.GlyphTableIndexArray = 'p'
    extractSurface1Display.GaussianRadius = 0.005
    extractSurface1Display.SetScaleArray = ['POINTS', 'p']
    extractSurface1Display.ScaleTransferFunction = 'PiecewiseFunction'
    extractSurface1Display.OpacityArray = ['POINTS', 'p']
    extractSurface1Display.OpacityTransferFunction = 'PiecewiseFunction'
    extractSurface1Display.DataAxesGrid = 'GridAxesRepresentation'
    extractSurface1Display.PolarAxes = 'PolarAxesRepresentation'
    extractSurface1Display.SelectInputVectors = ['POINTS', 'U']
    extractSurface1Display.WriteLog = ''

    # init the 'PiecewiseFunction' selected for 'ScaleTransferFunction'
    extractSurface1Display.ScaleTransferFunction.Points = [-1.0382322072982788, 0.0, 0.5, 0.0, 0.3021395206451416, 1.0, 0.5, 0.0]

    # init the 'PiecewiseFunction' selected for 'OpacityTransferFunction'
    extractSurface1Display.OpacityTransferFunction.Points = [-1.0382322072982788, 0.0, 0.5, 0.0, 0.3021395206451416, 1.0, 0.5, 0.0]

    # hide data in view
    Hide(anguilliformfoam, renderView1)

    # show color bar/color legend
    extractSurface1Display.SetScalarBarVisibility(renderView1, True)

    # update the view to ensure updated data information
    renderView1.Update()

    # create a new 'Calculator'
    calculator1 = Calculator(registrationName='Calculator1', Input=extractSurface1)
    calculator1.Function = ''

    # Properties modified on calculator1
    calculator1.ResultArrayName = 'Cp'
    calculator1.Function = '(p-0)/(0.5*1026*1^2)'

    # show data in view
    calculator1Display = Show(calculator1, renderView1, 'GeometryRepresentation')

    # get color transfer function/color map for 'Cp'
    cpLUT = GetColorTransferFunction('Cp')

    # trace defaults for the display properties.
    calculator1Display.Representation = 'Surface'
    calculator1Display.ColorArrayName = ['POINTS', 'Cp']
    calculator1Display.LookupTable = cpLUT
    calculator1Display.SelectTCoordArray = 'None'
    calculator1Display.SelectNormalArray = 'None'
    calculator1Display.SelectTangentArray = 'None'
    calculator1Display.OSPRayScaleArray = 'Cp'
    calculator1Display.OSPRayScaleFunction = 'PiecewiseFunction'
    calculator1Display.SelectOrientationVectors = 'U'
    calculator1Display.ScaleFactor = 0.1
    calculator1Display.SelectScaleArray = 'Cp'
    calculator1Display.GlyphType = 'Arrow'
    calculator1Display.GlyphTableIndexArray = 'Cp'
    calculator1Display.GaussianRadius = 0.005
    calculator1Display.SetScaleArray = ['POINTS', 'Cp']
    calculator1Display.ScaleTransferFunction = 'PiecewiseFunction'
    calculator1Display.OpacityArray = ['POINTS', 'Cp']
    calculator1Display.OpacityTransferFunction = 'PiecewiseFunction'
    calculator1Display.DataAxesGrid = 'GridAxesRepresentation'
    calculator1Display.PolarAxes = 'PolarAxesRepresentation'
    calculator1Display.SelectInputVectors = ['POINTS', 'U']
    calculator1Display.WriteLog = ''

    # init the 'PiecewiseFunction' selected for 'ScaleTransferFunction'
    calculator1Display.ScaleTransferFunction.Points = [-0.002023844458671109, 0.0, 0.5, 0.0, 0.0005889659271835121, 1.0, 0.5, 0.0]

    # init the 'PiecewiseFunction' selected for 'OpacityTransferFunction'
    calculator1Display.OpacityTransferFunction.Points = [-0.002023844458671109, 0.0, 0.5, 0.0, 0.0005889659271835121, 1.0, 0.5, 0.0]

    # hide data in view
    Hide(extractSurface1, renderView1)

    # show color bar/color legend
    calculator1Display.SetScalarBarVisibility(renderView1, True)

    # update the view to ensure updated data information
    renderView1.Update()

    # get opacity transfer function/opacity map for 'Cp'
    cpPWF = GetOpacityTransferFunction('Cp')

    # get 2D transfer function for 'Cp'
    cpTF2D = GetTransferFunction2D('Cp')

    # create a new 'Slice'
    slice1 = Slice(registrationName='Slice1', Input=calculator1)
    slice1.SliceType = 'Plane'
    slice1.HyperTreeGridSlicer = 'Plane'
    slice1.SliceOffsetValues = [0.0]

    # init the 'Plane' selected for 'SliceType'
    slice1.SliceType.Origin = [0.48713457584381104, -0.009652204811573029, 0.0]

    # init the 'Plane' selected for 'HyperTreeGridSlicer'
    slice1.HyperTreeGridSlicer.Origin = [0.48713457584381104, -0.009652204811573029, 0.0]

    # toggle interactive widget visibility (only when running from the GUI)
    HideInteractiveWidgets(proxy=slice1.SliceType)

    # Properties modified on slice1.SliceType
    slice1.SliceType.Normal = [0.0, 0.0, 1.0]

    # show data in view
    slice1Display = Show(slice1, renderView1, 'GeometryRepresentation')

    # trace defaults for the display properties.
    slice1Display.Representation = 'Surface'
    slice1Display.ColorArrayName = ['POINTS', 'Cp']
    slice1Display.LookupTable = cpLUT
    slice1Display.SelectTCoordArray = 'None'
    slice1Display.SelectNormalArray = 'None'
    slice1Display.SelectTangentArray = 'None'
    slice1Display.OSPRayScaleArray = 'Cp'
    slice1Display.OSPRayScaleFunction = 'PiecewiseFunction'
    slice1Display.SelectOrientationVectors = 'U'
    slice1Display.ScaleFactor = 0.09742691516876222
    slice1Display.SelectScaleArray = 'Cp'
    slice1Display.GlyphType = 'Arrow'
    slice1Display.GlyphTableIndexArray = 'Cp'
    slice1Display.GaussianRadius = 0.00487134575843811
    slice1Display.SetScaleArray = ['POINTS', 'Cp']
    slice1Display.ScaleTransferFunction = 'PiecewiseFunction'
    slice1Display.OpacityArray = ['POINTS', 'Cp']
    slice1Display.OpacityTransferFunction = 'PiecewiseFunction'
    slice1Display.DataAxesGrid = 'GridAxesRepresentation'
    slice1Display.PolarAxes = 'PolarAxesRepresentation'
    slice1Display.SelectInputVectors = ['POINTS', 'U']
    slice1Display.WriteLog = ''

    # init the 'PiecewiseFunction' selected for 'ScaleTransferFunction'
    slice1Display.ScaleTransferFunction.Points = [-0.002023844458671109, 0.0, 0.5, 0.0, 0.0005889659271835121, 1.0, 0.5, 0.0]

    # init the 'PiecewiseFunction' selected for 'OpacityTransferFunction'
    slice1Display.OpacityTransferFunction.Points = [-0.002023844458671109, 0.0, 0.5, 0.0, 0.0005889659271835121, 1.0, 0.5, 0.0]

    # hide data in view
    Hide(calculator1, renderView1)

    # show color bar/color legend
    slice1Display.SetScalarBarVisibility(renderView1, True)

    # update the view to ensure updated data information
    renderView1.Update()

    # get layout
    layout1 = GetLayout()

    # split cell
    layout1.SplitHorizontal(0, 0.5)

    # set active view
    SetActiveView(None)

    # Create a new 'SpreadSheet View'
    spreadSheetView1 = CreateView('SpreadSheetView')
    spreadSheetView1.ColumnToSort = ''
    spreadSheetView1.BlockSize = 1024

    # show data in view
    slice1Display_1 = Show(slice1, spreadSheetView1, 'SpreadSheetRepresentation')

    # assign view to a particular cell in the layout
    AssignViewToLayout(view=spreadSheetView1, layout=layout1, hint=2)

    # Properties modified on spreadSheetView1
    spreadSheetView1.HiddenColumnLabels = []

    # Properties modified on spreadSheetView1
    spreadSheetView1.HiddenColumnLabels = ['Block Name', 'Block Number', 'Point ID', 'cellTypes', 'Cp', 'H', 'H_Magnitude', 'HbyA', 'HbyA_Magnitude', 'k', 'nut', 'omega', 'p', 'Points', 'Points_Magnitude', 'rAU', 'U', 'U_Magnitude', 'zoneID']

    # Properties modified on spreadSheetView1
    spreadSheetView1.HiddenColumnLabels = ['Block Number', 'Point ID', 'cellTypes', 'Cp', 'H', 'H_Magnitude', 'HbyA', 'HbyA_Magnitude', 'k', 'nut', 'omega', 'p', 'Points', 'Points_Magnitude', 'rAU', 'U', 'U_Magnitude', 'zoneID']

    # Properties modified on spreadSheetView1
    spreadSheetView1.HiddenColumnLabels = ['Block Number', 'Point ID', 'cellTypes', 'H', 'H_Magnitude', 'HbyA', 'HbyA_Magnitude', 'k', 'nut', 'omega', 'p', 'Points', 'Points_Magnitude', 'rAU', 'U', 'U_Magnitude', 'zoneID']

    # Properties modified on spreadSheetView1
    spreadSheetView1.HiddenColumnLabels = ['Block Number', 'Point ID', 'cellTypes', 'H', 'H_Magnitude', 'HbyA', 'HbyA_Magnitude', 'k', 'nut', 'omega', 'p', 'Points_Magnitude', 'rAU', 'U', 'U_Magnitude', 'zoneID']

    # export view
    ExportView(str(file.parent.joinpath('CP', file.stem + 'CP_0.csv')), view=spreadSheetView1)
    
    for i, time in enumerate(np.arange(1,21,1)):
        # go to next frame
        animationScene1.GoToNext()

        # export view
        ExportView(str(file.parent.joinpath('CP', file.stem + 'CP_' + str(time) + '.csv')), view=spreadSheetView1)


    #================================================================
    # addendum: following script captures some of the application
    # state to faithfully reproduce the visualization during playback
    #================================================================

    #--------------------------------
    # saving layout sizes for layouts

    # layout/tab size in pixels
    layout1.SetSize(1167, 794)

    #-----------------------------------
    # saving camera placements for views

    # current camera placement for renderView1
    renderView1.CameraPosition = [0.48713457584381104, -0.009652204811573029, 2.726505743358028]
    renderView1.CameraFocalPoint = [0.48713457584381104, -0.009652204811573029, 0.0]
    renderView1.CameraParallelScale = 0.7056716129624633

    #--------------------------------------------
    # uncomment the following to render all views
    # RenderAllViews()
    # alternatively, if you want to write images, you can use SaveScreenshot(...).
    Disconnect()
    Connect()